/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.util;

import com.inprise.vbroker.util.StringFunctions;
import com.inprise.vbroker.util.UnGuardedHashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DriverUsage {
    private static UnGuardedHashtable _services = new UnGuardedHashtable();
    private static UnGuardedHashtable _raw = new UnGuardedHashtable();
    private static String[] _generalOptions;
    private static String[] _serviceOptions;
    private static String[] _rawOptions;
    private static String translationTableName;
    private static ResourceBundle _messageTranslations;
    public static final String _lineSep;

    public static String expandUsage(String current, String[] entries) throws MissingResourceException {
        if (entries != null) {
            for (int i = 0; i < entries.length; ++i) {
                try {
                    current = String.valueOf(current).concat(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(_lineSep)).append("  ").append(DriverUsage.getMesg(entries[i])))));
                    continue;
                }
                catch (MissingResourceException e) {
                    System.err.println(String.valueOf(new StringBuffer("Internal error: ").append(e.getMessage()).append(" ").append(entries[i])));
                    String string = "";
                    return string;
                }
            }
        }
        return current;
    }

    public static final String getMesg(String mesgName) throws MissingResourceException {
        return _messageTranslations.getString(mesgName);
    }

    private static String getOptionsString(String option) {
        String options = DriverUsage.getMesg(option);
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            try {
                options = String.valueOf(options).concat(String.valueOf(",".concat(String.valueOf(DriverUsage.getMesg("DriverUsage.generalOptionsWindows")))));
            }
            catch (MissingResourceException missingResourceException) {}
        } else {
            try {
                options = String.valueOf(options).concat(String.valueOf(",".concat(String.valueOf(DriverUsage.getMesg("DriverUsage.generalOptionsUnix")))));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return options;
    }

    public static void init() {
        try {
            String[] raw;
            String[] services = StringFunctions.toStringArray(DriverUsage.getMesg("DriverUsage.services"), ",");
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    _services.put(services[i], services[i]);
                }
            }
            if ((raw = StringFunctions.toStringArray(DriverUsage.getMesg("DriverUsage.raw"), ",")) != null) {
                for (int i = 0; i < raw.length; ++i) {
                    _raw.put(raw[i], raw[i]);
                }
            }
            _generalOptions = StringFunctions.toStringArray(DriverUsage.getOptionsString("DriverUsage.generalOptions"), ",");
            _serviceOptions = StringFunctions.toStringArray(DriverUsage.getOptionsString("DriverUsage.serviceOptions"), ",");
            _rawOptions = StringFunctions.toStringArray(DriverUsage.getOptionsString("DriverUsage.rawOptions"), ",");
        }
        catch (MissingResourceException f) {
            System.err.println(String.valueOf(new StringBuffer("Internal error: ").append(f.getMessage()).append(" one of:")));
            System.err.println("DriverUsage.services, DriverUsage.raw, DriverUsage.generalOptions, DriverUsage.serviceOptions, DriverUsage.rawOptions");
        }
    }

    public static void main(String[] args) {
        DriverUsage.printUsage(args[0]);
    }

    public static void printUsage(String toolName) {
        try {
            DriverUsage.init();
            String usage = DriverUsage.getMesg("DriverUsage.preamble");
            usage = DriverUsage.expandUsage(usage, _generalOptions);
            if (_services.get(toolName) != null) {
                usage = DriverUsage.expandUsage(usage, _serviceOptions);
            }
            if (_raw.get(toolName) == null) {
                usage = DriverUsage.expandUsage(usage, _rawOptions);
            }
            DriverUsage.untranslatedMessage(usage);
        }
        catch (MissingResourceException e) {
            System.err.println(String.valueOf(new StringBuffer("Internal error: ").append(e.getMessage()).append(" DriverUsage.preamble")));
            return;
        }
    }

    private static final void untranslatedMessage(String message) {
        System.out.println(message);
    }

    static {
        translationTableName = "com.inprise.vbroker.util.DriverUsageMessages";
        _messageTranslations = ResourceBundle.getBundle(translationTableName);
        _lineSep = System.getProperty("line.separator");
    }
}

